/**
 * Patches console methods to exit the workUnitAsyncStorage so that inside the host implementation
 * sync IO can be called. This is relevant for example with runtimes that patch console methods to
 * prepend a timestamp to the log output.
 *
 * Note that this will only exit for already installed patched console methods. If you further patch
 * the console method after this and add any sync IO there it will trigger sync IO warnings while prerendering.
 *
 * This is a pragmatic concession because layering the patches if you install your own log implementation
 * after they are installed is very tricky to do correctly because the order matters
 */
export {};
