import PageLayout from "@/src/components/PageLayout";
import NumberedSection from "@/src/components/NumberedSection";
import Image from "next/image";

export default function AboutPage() {
  return (
    <PageLayout>
      <h1 className="text-4xl md:text-[2.5rem] font-bold leading-tight header-font">
        {["A Message from", "our founder"].map((line, index) => (
          <span
            key={index}
            className="block hover:text-[rgb(var(--accent))] transition-colors duration-500"
          >
            {line}
          </span>
        ))}
      </h1>
      <NumberedSection
        title="It all began with a brand I genuinely loved"
        content={
          <>
            A strong business selling natural soap on Instagram. What drew me in
            wasn&apos;t just the product—it was the founder&apos;s story. You
            could tell, from the way she shared her journey, her care, her craft
            that soap-making wasn&apos;t just a business to her—it was her way
            of serving others. Her purpose was to create high-quality,
            chemical-free soap that people could trust. I admired her, and I
            wanted to buy from this person.
            <br />
            <br />
            So when I reached out excited to ask which soap would be best for
            me, I expected to see her vision and heart in the conversation, But
            what I got was... just answers.
            <br />
            No thoughtful guidance. &quot;No feeling that they cared whether I
            made the right choice or not&quot;.
            <br />
            The response wasn&apos;t rude—it was just flat. Mechanical.
            Transactional.
            <br />
            <br />
            And in that moment, the relationship I hoped to build with the brand
            felt like it disappeared. And most importantly, I was very
            disappointed.
            <br />
            The Founder&apos;s heart never reached me through the screen.
          </>
        }
      />

      <div className="line" />

      <NumberedSection
        title="That's when I saw the bigger problem:"
        content={
          <>
            So many brands with real heart were losing sales and loyalty because
            their online conversations lacked that care.{" "}
            <span className="underline">
              They weren&apos;t just losing money—they were losing
              relationships.
            </span>
            <br />
            They had beautiful visions, passionate founders, and quality
            products—but the customer experience felt soulless.
            <br />
            They weren&apos;t just losing money—they were losing relationships.
          </>
        }
      />

      <div className="line" />

      <NumberedSection
        title="That's when I decided to build Ocean of Olives"
        content={
          <>
            An AI agency that creates chatbots with Empathy Before Intelligence,
            designed to speak the way passionate founders would. We help
            e-commerce brands, especially those on social platforms, translate
            their heart into every customer interaction.
            <br />
            You might be thinking, &quot;That&apos;s too good to be true. No AI
            can care like a human, even some humans are sometimes tired and lose
            the ability to care.&quot;
            <br />
            But that&apos;s exactly the difference. We don&apos;t just build
            smart bots. We build emotionally intelligent ones.
            <br />
            And we&apos;re here to prove it—one heartfelt conversation at a
            time.
          </>
        }
      />

      <div className="flex flex-col  justify-end  items-end gap-8 md:gap-12 mt-12 md:mt-20">
        {/* Founder Image */}
        <div className="w-32 md:w-56 aspect-784/1376 rounded-xl overflow-hidden shrink-0">
          <Image
            src="/imgs/founder.webp"
            alt="Founder"
            width={784}
            height={1376}
            className="w-full h-full object-cover"
          />
        </div>
      </div>
    </PageLayout>
  );
}
