import type { Metadata } from "next";
import { Fraunces, Ancizar_Serif } from "next/font/google";
import "./globals.css";
import TopHeader from "../components/TopHeader";
import Header from "../components/Header";
import Footer from "../components/Footer";

const ancizar = Ancizar_Serif({
  subsets: ["latin"],
  weight: ["400", "500", "600", "700"],
  variable: "--font-ancizar",
});
const fraunces = Fraunces({
  variable: "--font-fraunces",
  subsets: ["latin"],
  weight: ["400", "500", "600", "700"],
});

export const metadata: Metadata = {
  metadataBase: new URL("https://oceanofolives.com"),
  title: {
    default: "Ocean of Olives - AI Chatbots with Encoded Empathy",
    template: "%s | Ocean of Olives",
  },
  description:
    "We help e-commerce brands build chatbots that encode empathy with AI intelligence. Delivering exceptional customer experiences on social messaging platforms that boost sales and increase loyalty.",
  keywords: [
    "AI chatbots",
    "empathy AI",
    "e-commerce chatbots",
    "customer experience",
    "WhatsApp chatbot",
    "Facebook Messenger bot",
    "Instagram DM automation",
    "conversational AI",
    "brand voice AI",
  ],
  authors: [{ name: "Ocean of Olives" }],
  creator: "Ocean of Olives",
  publisher: "Ocean of Olives",
  formatDetection: {
    email: false,
    address: false,
    telephone: false,
  },
  openGraph: {
    type: "website",
    locale: "en_US",
    url: "https://oceanofolives.com",
    title: "Ocean of Olives - AI Chatbots with Encoded Empathy",
    description:
      "Building emotionally intelligent chatbots for e-commerce brands. Encode your brand voice into every customer interaction.",
    siteName: "Ocean of Olives",
  },
  twitter: {
    card: "summary_large_image",
    title: "Ocean of Olives - AI Chatbots with Encoded Empathy",
    description:
      "Building emotionally intelligent chatbots for e-commerce brands.",
  },
  robots: {
    index: true,
    follow: true,
    googleBot: {
      index: true,
      follow: true,
      "max-video-preview": -1,
      "max-image-preview": "large",
      "max-snippet": -1,
    },
  },
  viewport: {
    width: "device-width",
    initialScale: 1,
    maximumScale: 1,
  },
};

const jsonLd = {
  "@context": "https://schema.org",
  "@type": "Organization",
  name: "Ocean of Olives",
  alternateName: "Ocean of Olives AI",
  url: "https://oceanofolives.com",
  logo: "https://oceanofolives.com/icon.svg",
  description:
    "We help e-commerce brands build chatbots that encode empathy with AI intelligence. Delivering exceptional customer experiences on social messaging platforms.",
  foundingDate: "2024",
  // sameAs: ["https://www.linkedin.com/company/Oceanai/"],
  contactPoint: {
    "@type": "ContactPoint",
    contactType: "Customer Service",
    email: "support@oceanofolives.com",
  },
  areaServed: "Worldwide",
  knowsAbout: [
    "AI Chatbots",
    "Conversational AI",
    "E-commerce Solutions",
    "Customer Experience",
    "WhatsApp Business",
    "Messenger Bots",
  ],
};

export default function RootLayout({
  children,
}: Readonly<{
  children: React.ReactNode;
}>) {
  return (
    <html lang="en" className="scroll-smooth">
      <head>
        <script
          type="application/ld+json"
          dangerouslySetInnerHTML={{ __html: JSON.stringify(jsonLd) }}
        />
        <meta
          name="google-site-verification"
          content="WKXnL-eH-DaINfRss86opnxuBRl7RBy2c2F6W7Xa9lU"
        />
      </head>
      <body
        className={`${fraunces.variable} ${ancizar.variable} antialiased transition-colors duration-300`}
      >
        <TopHeader />
        <Header />
        <main className="relative z-10 transition-opacity duration-300">
          {children}
        </main>
        <Footer />
      </body>
    </html>
  );
}
