import PageLayout from "@/src/components/PageLayout";
import PageHero from "@/src/components/PageHero";
import NumberedSection from "@/src/components/NumberedSection";
import GetInTouchButton from "../components/GetInTouchButton";

export default function Home() {
  return (
    <PageLayout>
      <PageHero
        title={["We are Ocean", "of Olives"]}
        subtitle={
          <>
            <span className="text-[1.8rem]! md:text-[2rem]! block mb-6">
              Empathy...Encoded
            </span>
            We help you help your customers with your own brand&apos;s voice.
          </>
        }
      />

      <NumberedSection
        title="Customer conversations have lost their humanity"
        content={
          <>
            Currently it is auto-replies, robotic, flat, transactional answers,
            or even worse….Silence.
            <br />
            Brands sound robotic. Support feels mechanical. Customers feel
            unheard.
            <br />
            We believe there is a difference between <b>answering</b> and{" "}
            <b>truly helping</b>.
          </>
        }
      />
      <div className="line" />

      <NumberedSection
        title="We exist to restore empathy in digital communication"
        content={
          <>
            We believe every business deserves a voice that reflects its
            founder&apos;s values, principles, and heart — a voice that builds
            trust, connection, and loyalty.
            <br />
            To make every conversation feel human again.
            <br />
            We combine emotional intelligence with advanced AI to ENCODE your
            founder&apos;s voice, tone, values, and principles into every
            interaction.
            <br />
            We study your brand deeply — your philosophy, your story, your
            energy — and we build chatbots that think, respond, and care the way
            you do.
          </>
        }
      />
      <div className="line" />
      <div className="flex flex-col gap-8 md:gap-10">
        <div>
          {" "}
          <NumberedSection
            title="Our emotionally intelligent conversation systems are built on:"
            content=""
          />
          <div className="line" />
        </div>

        <NumberedSection
          number="01"
          title="Intent Interpretation"
          content="Understanding customer's intent, tone, and conversation context without the customer spelling it out."
        />

        <NumberedSection
          number="02"
          title="Thoughtful Guidance"
          content="Guide with thoughtful recommendations instead of waiting for the perfect question."
        />

        <NumberedSection
          number="03"
          title="Brand Voice Modeling"
          content="This allows your customers to feel like they're speaking to the heart of your brand — not a machine."
        />
      </div>

      <div className="line" />

      <NumberedSection
        title="Building Chatbots with Encoded Empathy"
        content={
          <>
            We are Ocean of Olives, an AI Agency specialized in Building
            Chatbots that Encode Empathy with AI Intelligence. We help
            e-commerce stores on social messaging platforms (Brand Website,
            Facebook Messenger, WhatsApp, Instagram DMs & Telegram) delivering
            exceptional customer experiences that boost sales and increase
            customer loyalty.
          </>
        }
      />
      <div className="w-full flex justify-end">
        <GetInTouchButton />
      </div>
    </PageLayout>
  );
}
