import PageLayout from "@/src/components/PageLayout";
import { PrivacySections } from "@/src/components/sections/PrivacySections";

export default function PrivacyPage() {
  return (
    <PageLayout>
      <div>
        <h1 className="text-[2rem] md:text-[2.5rem] font-bold header-font">
          Privacy Policy
        </h1>
        <p className="text-[rgb(var(--tertiary))] text-[0.875rem] mt-4 opacity-60">
          Last updated: {new Date().toLocaleDateString()}
        </p>
      </div>

      <div className="line" />

      <div className="space-y-16 md:space-y-20">
        <PrivacySections />
      </div>
    </PageLayout>
  );
}
