import PageLayout from "@/src/components/PageLayout";
import { TermsSections } from "@/src/components/sections/TermsSections";

export default function TermsPage() {
  return (
    <PageLayout>
      <div>
        <h1 className="text-[2rem] md:text-[2.5rem] font-bold header-font">
          Terms of Use
        </h1>
        <p className="text-[rgb(var(--tertiary))] text-[0.875rem] mt-4 opacity-60">
          Last updated: {new Date().toLocaleDateString()}
        </p>
      </div>

      <div className="line" />

      <div className="space-y-16 md:space-y-20">
        <TermsSections />
      </div>
    </PageLayout>
  );
}
