"use client";

import Link from "next/link";
import { useState } from "react";
import MobileMenu from "./Header/MobileMenu";
import DesktopNav from "./Header/DesktopNav";
import Logo from "./Logo";

// Navigation Items
const NAV_ITEMS = [
  { label: "Home", href: "/" },
  { label: "About", href: "/about" },
];

export default function Header() {
  const [isMenuOpen, setIsMenuOpen] = useState(false);

  return (
    <>
      {/* Mobile Menu Component */}
      <MobileMenu
        isOpen={isMenuOpen}
        onClose={() => setIsMenuOpen(false)}
        navItems={NAV_ITEMS}
      />

      <header className="sticky md:fixed z-50 pointer-events-none top-0 md:top-50 right-0 left-0 w-full md:bg-transparent bg-[rgb(var(--light1))]">
        <div className="grid grid-cols-6 gap-5 md:grid-cols-12 px-7 sm:px-8 md:px-10 lg:px-7 max-w-screen-2xl mx-auto">
          <div className="col-start-1 col-end-7 md:col-end-3 lg:col-end-4 xl:col-start-2 flex flex-row justify-between items-center md:items-start md:flex-col gap-4 pointer-events-auto py-4.5 md:py-0">
            {/* Logo - visible on mobile only */}
            <Link href="/" className="relative group md:hidden">
              <Logo />
            </Link>

            {/* Desktop Navigation Component */}
            <DesktopNav navItems={NAV_ITEMS} />

            {/* Mobile Hamburger Menu */}
            <button
              onClick={() => setIsMenuOpen(!isMenuOpen)}
              className={`md:hidden! inline-block hamburger hamburger--spin ${
                isMenuOpen ? "is-active" : ""
              }`}
              aria-label="Toggle menu"
            >
              <span className="hamburger-box">
                <span className="hamburger-inner"></span>
              </span>
            </button>
          </div>
        </div>
      </header>
    </>
  );
}
