"use client";

import Link from "next/link";
import { usePathname } from "next/navigation";

interface NavItem {
  label: string;
  href: string;
  external?: boolean;
}

interface DesktopNavProps {
  navItems: NavItem[];
}

export default function DesktopNav({
  navItems,
}: DesktopNavProps) {
  const pathname = usePathname();

  return (
    <div className="hidden md:flex flex-col gap-4">
      {/* Main Navigation */}
      <ul className="flex flex-col gap-1.5">
        {navItems.map((item) => {
          const isActive = pathname === item.href;
          return (
            <li key={item.href} className="relative">
              <Link
                href={item.href}
                className={`block transition-all duration-300 ease-out relative group ${
                  isActive
                    ? "text-[rgb(var(--sidebar))] font-[630]"
                    : "opacity-50 hover:opacity-100 text-[rgb(var(--sidebar-light))] hover:font-[630] hover:translate-x-1"
                }`}
              >
                {item.label}
              </Link>
            </li>
          );
        })}
      </ul>

    </div>
  );
}
