"use client";

import Link from "next/link";
import { usePathname } from "next/navigation";
import { useEffect } from "react";

interface NavItem {
  label: string;
  href: string;
  external?: boolean;
}

interface MobileMenuProps {
  isOpen: boolean;
  onClose: () => void;
  navItems: NavItem[];
}

export default function MobileMenu({
  isOpen,
  onClose,
  navItems,
}: MobileMenuProps) {
  const pathname = usePathname();

  useEffect(() => {
    if (isOpen) {
      document.body.style.overflow = "hidden";
    } else {
      document.body.style.overflow = "";
    }
    return () => {
      document.body.style.overflow = "";
    };
  }, [isOpen]);

  return (
    <div
      className={`fixed top-0 h-screen left-0 w-full z-30 overflow-y-scroll md:hidden transition-all duration-300 ${
        isOpen ? "opacity-100 visible" : "opacity-0 invisible"
      }`}
    >
      {/* Menu Content */}
      <div
        className={`top-14 absolute w-full z-10 transition-transform duration-300 ${
          isOpen ? "translate-y-0" : "-translate-y-4"
        }`}
      >
        {/* Navigation */}
        <div className="pt-6 pb-5 bg-[rgb(var(--light1))] px-6 rounded-b-xl">
          {/* Main Navigation */}
          <ul className="flex flex-col gap-5 pb-6 ">
            {navItems.map((item) => {
              const isActive = pathname === item.href;
              return (
                <li key={item.href}>
                  <Link
                    href={item.href}
                    className={`block transition-all duration-300 ease-out ${
                      isActive
                        ? "text-[rgb(var(--sidebar))] font-[630]"
                        : "opacity-50 hover:opacity-100 text-[rgb(var(--sidebar-light))] hover:font-[630] hover:translate-x-2"
                    }`}
                    onClick={onClose}
                  >
                    {item.label}
                  </Link>
                </li>
              );
            })}
          </ul>
        </div>
      </div>

      {/* Background Overlay */}
      <div
        onClick={onClose}
        className={`absolute h-full w-full bg-black/30 transition-opacity duration-300 ${
          isOpen ? "opacity-100" : "opacity-0"
        }`}
      />
    </div>
  );
}
