interface LogoProps {
  className?: string;
  showText?: boolean;
}

export default function Logo({
  className = "w-10 h-fit",
  showText = false,
}: LogoProps) {
  return (
    <svg
      xmlns="http://www.w3.org/2000/svg"
      viewBox={showText ? "730 360 460 360" : "800 360 320 160"}
      preserveAspectRatio="xMidYMid meet"
      className={className}
      role="img"
      aria-label="Logo"
      style={{ display: "block", maxWidth: "100%", height: "auto" }}
    >
      <defs>
        <style>
          {`
            .logo-ocean {
              fill: rgb(0, 49, 83);
              transition: fill 0.3s ease;
            }
            .logo-accent {
              fill: rgb(55, 62, 2);
              transition: fill 0.3s ease;
            }    
            .txt{
              fill: white;
              transition: fill 0.3s ease;
            }
          `}
        </style>
      </defs>

      <g>
        <path
          className={`logo-accent`}
          d="M1081.01,399.05l14.07-24.47h-14.41l-9.94,17.29c-7.28-3.91-15.45-6.1-24.08-6.1-30.49,0-55.2,27.32-55.2,61.01,0,19.14,7.98,36.21,20.45,47.39l-12.68,22.04h14.41l8.5-14.78c7.39,4.06,15.71,6.35,24.52,6.35,30.49,0,55.2-27.32,55.2-61.01,0-19.33-8.14-36.55-20.84-47.73ZM1017.6,446.78c0-21.41,13.03-38.83,29.05-38.83,4.52,0,8.78,1.43,12.6,3.89l-34.62,60.2c-4.37-6.8-7.03-15.61-7.03-25.26ZM1046.65,485.61c-4.68,0-9.1-1.52-13.02-4.17l34.73-60.39c4.55,6.86,7.35,15.85,7.35,25.72,0,21.41-13.03,38.83-29.05,38.83Z"
        />

        <path
          className={`logo-ocean`}
          d="M969.03,428.19c-4.67-2.79-10.89-1.47-14.24,2.75-3.08,3.88-6.33,7.07-9.64,9.46-8.37,6.04-19.85,5.59-28.58-1.14-53.55-41.23-95.59,7.7-96.01,8.2-3.72,4.44-3.04,10.95,1.52,14.6,4.55,3.64,11.3,3,15.06-1.41,2.38-2.78,21.59-23.89,46.83-16.3,6.39,1.92,12.07,5.56,16.91,10.04,8.79,8.15,35.23,27.38,64.03-3.15h-.02c2.45-2.36,4.81-4.97,7.07-7.84,3.82-4.85,2.57-11.93-2.93-15.22Z"
        />

        {showText && (
          <g className={`txt`}>
            <path d="M789.38,565.59c0-24.35,14.85-38.69,34.6-38.69s34.5,14.34,34.5,38.69-14.8,38.59-34.5,38.59-34.6-14.34-34.6-38.59ZM844.89,565.59c0-17.27-8.69-26.62-20.91-26.62s-21.06,9.39-21.06,26.62,8.74,26.52,21.06,26.52,20.91-9.34,20.91-26.52Z" />
            <path d="M868.18,575.23c0-17.58,10.51-29.24,26.97-29.24,12.58,0,21.92,6.72,24.35,17.73l-12.27,2.58c-1.41-5.86-5.61-9.65-11.97-9.65-9.14,0-13.69,7.98-13.69,18.54s4.55,18.49,13.69,18.49c6.47,0,10.76-3.94,12.12-10.05l12.27,2.58c-2.42,11.26-11.82,18.13-24.5,18.13-16.47,0-26.97-11.72-26.97-29.09Z" />
            <path d="M928.43,575.28c0-17.38,10.4-29.3,26.57-29.3,13.79,0,25.81,8.69,25.81,28.49v4.14h-39.29c.35,10.05,6.06,15.41,14.5,15.41,5.76,0,10.1-2.53,11.87-7.32l12.07,2.47c-2.73,9.14-11.51,15.15-24.09,15.15-17.02,0-27.43-11.36-27.43-29.04ZM968.03,569.68c-.76-8.08-5.15-13.38-12.98-13.38s-12.88,5.86-13.49,13.38h26.47Z" />
            <path d="M989.95,587.3c0-12.73,10.61-15.96,21.52-17.12,9.8-1.06,13.94-1.21,13.94-5.1v-.25c0-5.51-3.43-8.74-9.85-8.74s-10.46,3.38-11.82,7.12l-12.17-2.47c3.33-9.95,12.63-14.75,23.94-14.75,10.61,0,23.03,4.39,23.03,19.45v37.73h-12.58v-7.78h-.51c-2.47,4.85-7.83,8.94-16.62,8.94-10.76,0-18.89-5.91-18.89-17.02ZM1025.51,582.91v-6.67c-1.77,1.41-9.09,2.32-12.48,2.78-5.91.81-10.35,2.98-10.35,8.13s3.99,7.42,9.55,7.42c8.08,0,13.28-5.4,13.28-11.67Z" />
            <path d="M1065.61,603.16h-13.13v-56.47h12.43l.15,11.26c3.33-7.93,9.19-11.97,17.48-11.97,11.62,0,19.29,7.68,19.29,21.26v35.91h-13.13v-33.89c0-7.58-4.14-12.12-11.01-12.12s-12.07,4.75-12.07,12.93v33.08Z" />
            <path d="M736.62,666.68c0-24.35,14.85-38.69,34.6-38.69s34.5,14.34,34.5,38.69-14.8,38.59-34.5,38.59-34.6-14.34-34.6-38.59ZM792.13,666.68c0-17.27-8.69-26.62-20.91-26.62s-21.06,9.39-21.06,26.62,8.74,26.52,21.06,26.52,20.91-9.34,20.91-26.52Z" />
            <path d="M847.59,658.09h-12.22v46.17h-13.08v-46.17h-10.35v-10.3h10.35v-5.4c0-11.26,7.83-16.92,17.53-16.92,4.65,0,8.38.96,10.1,1.57l-2.68,10.2c-1.11-.35-2.83-.81-5-.81-4.95,0-6.87,2.53-6.87,6.97v4.39h12.22v10.3Z" />
            <path d="M882.39,666.68c0-24.35,14.85-38.69,34.6-38.69s34.5,14.34,34.5,38.69-14.8,38.59-34.5,38.59-34.6-14.34-34.6-38.59ZM937.9,666.68c0-17.27-8.69-26.62-20.91-26.62s-21.06,9.39-21.06,26.62,8.74,26.52,21.06,26.52,20.91-9.34,20.91-26.52Z" />
            <path d="M976.79,704.26h-13.13v-75.26h13.13v75.26Z" />
            <path d="M989.67,632.58c0-3.99,3.43-7.17,7.63-7.17s7.68,3.18,7.68,7.17-3.49,7.22-7.68,7.22-7.63-3.23-7.63-7.22ZM990.73,647.79h13.13v56.47h-13.13v-56.47Z" />
            <path d="M1012.81,647.79h14.04l10.3,30.71c1.67,5,2.93,10,4.19,15.15,1.21-5.1,2.42-10.15,4.09-15.15l10.25-30.71h13.94l-21.11,56.47h-14.7l-21.01-56.47Z" />
            <path d="M1074.12,676.37c0-17.38,10.4-29.3,26.57-29.3,13.79,0,25.81,8.69,25.81,28.49v4.14h-39.3c.35,10.05,6.06,15.41,14.5,15.41,5.76,0,10.1-2.53,11.87-7.32l12.07,2.47c-2.73,9.14-11.52,15.15-24.09,15.15-17.02,0-27.43-11.36-27.43-29.04ZM1113.72,670.77c-.76-8.08-5.15-13.38-12.98-13.38s-12.88,5.86-13.49,13.38h26.47Z" />
            <path d="M1135.24,689.41l12.27-2.32c1.52,5.61,5.45,8.28,11.87,8.28s10.56-2.93,10.56-6.77c0-3.28-2.47-5.35-7.63-6.47l-9.65-2.07c-10.66-2.32-15.86-7.53-15.86-15.81,0-10.46,9.24-17.17,22.78-17.17,12.78,0,20.2,5.81,22.48,14.55l-11.72,2.32c-1.31-3.94-4.55-7.07-10.61-7.07-5.56,0-9.8,2.73-9.8,6.57,0,3.28,2.27,5.35,8.03,6.62l9.6,2.02c10.71,2.27,15.81,7.32,15.81,15.25,0,10.71-10,18.08-24.24,18.08-12.98,0-21.92-5.76-23.89-16.01Z" />
          </g>
        )}
      </g>
    </svg>
  );
}
