import { ReactNode } from "react";

interface NumberedSectionProps {
  number?: string;
  title: string;
  content: ReactNode;
}

export default function NumberedSection({
  number,
  title,
  content,
}: NumberedSectionProps) {
  return (
    <div>
      {number && (
        <p className="text-[1rem] md:text-[1.25rem] text-[rgb(var(--main))]/60 pointer-events-none select-none">
          {number}
        </p>
      )}
      <div className="mt-8 flex flex-col gap-10">
        <div>
          <h2 className="font-bold header-font text-xl! md:text-[1.625rem]!">
            {title}
          </h2>
          <p className="text-[1rem] md:text-[1.25rem] text-[#474747] mt-4">
            {content}
          </p>
        </div>
      </div>
    </div>
  );
}
