import { ReactNode } from "react";

interface PageHeroProps {
  title: string[];
  description?: ReactNode;
  subtitle?: string | ReactNode;
}

export default function PageHero({
  title,
  description,
  subtitle,
}: PageHeroProps) {
  return (
    <>
      {/* Hero Section */}
      <div>
        <h1 className="text-4xl md:text-[2.5rem] font-bold leading-tight header-font">
          {title.map((line, index) => (
            <span
              key={index}
              className="block hover:text-[rgb(var(--accent))] transition-colors duration-500"
            >
              {line}
            </span>
          ))}
        </h1>
        {subtitle && (
          <p className="header-font font-bold text-[1.3rem]! md:text-[1.6rem]! mt-2">
            {subtitle}
          </p>
        )}
      </div>

      {description && (
        <div className="text-[1rem] md:text-[1.25rem] space-y-5">
          <p className="text-[rgb(var(--main))]/60 leading-relaxed">
            {description}
          </p>
        </div>
      )}

      <div className="line" />
    </>
  );
}
