import { ReactNode } from "react";

interface PageLayoutProps {
  children: ReactNode;
}

export default function PageLayout({ children }: PageLayoutProps) {
  return (
    <div className="relative z-0 ">
      <div className="w-full bg-[rgb(var(--light1))] relative z-10">
        <div className="page grid grid-cols-6 gap-5 md:grid-cols-12 max-w-screen-2xl mx-auto px-7 sm:px-8 md:px-10 lg:px-20 pt-24 md:pt-28 z-10 min-h-screen">
          <div className="col-start-1 col-end-7 md:col-start-4 md:col-end-12 lg:col-end-10">
            <div className="flex flex-col gap-12 md:gap-20 pb-24 md:pb-32">
              {children}
            </div>
          </div>
        </div>
        <div className="absolute -bottom-5 w-full rounded-b-xl h-14 bg-[rgb(var(--light1))] translate-y-1/2" />
      </div>
    </div>
  );
}
