import { ReactNode } from "react";

interface PolicyContentProps {
  children: ReactNode;
}

export function PolicyText({ children }: PolicyContentProps) {
  return (
    <p className="text-[1rem] md:text-[1.25rem] text-[rgb(var(--main))]/60 leading-relaxed">
      {children}
    </p>
  );
}

export function PolicyList({ children }: PolicyContentProps) {
  return (
    <ul className="text-[1rem] md:text-[1.25rem] text-[rgb(var(--main))]/60 leading-relaxed space-y-3 ml-1">
      {children}
    </ul>
  );
}

export function PolicyListItem({ children }: PolicyContentProps) {
  return (
    <li className="flex items-start gap-3">
      <span className="text-[rgb(var(--main))] opacity-30 mt-1.5">—</span>
      <span>{children}</span>
    </li>
  );
}

export function PolicyContent({ children }: PolicyContentProps) {
  return <div className="space-y-6">{children}</div>;
}

export function PolicyLink({
  href,
  children,
}: {
  href: string;
  children: ReactNode;
}) {
  return (
    <a
      href={href}
      className="underline hover:text-[rgb(var(--accent))] underline-offset-4 decoration-2 hover:decoration-[rgb(var(--accent))] transition-all duration-300"
    >
      {children}
    </a>
  );
}
