import { ReactNode } from "react";

interface PolicySectionProps {
  number: string;
  title: string;
  children: ReactNode;
}

export default function PolicySection({
  number,
  title,
  children,
}: PolicySectionProps) {
  return (
    <section className="relative pl-10 md:pl-14 group">
      <div className="absolute left-0 top-0 flex flex-col items-center gap-3">
        <span className="text-[0.875rem] md:text-[1rem] font-bold text-[rgb(var(--tertiary))] opacity-50 group-hover:opacity-70 transition-opacity duration-300">
          {number}
        </span>
        <div className="w-0.5 flex-1 bg-linear-to-b from-[rgb(var(--tertiary))] to-transparent opacity-20" />
      </div>
      <h2 className="text-[1.25rem] md:text-[1.5rem] font-bold mb-6 text-black header-font group-hover:tracking-tight transition-all duration-300">
        {title}
      </h2>
      {children}
    </section>
  );
}
