import Link from "next/link";
import Logo from "./Logo";
import GetInTouchButton from "./GetInTouchButton";

export default function TopHeader() {
  return (
    <div className="hidden md:block w-full md:pt-5 md:pb-3 top-0 left-0 right-0 z-40 bg-[rgb(var(--light1))]">
      <div className="max-w-screen-2xl mx-auto px-7 sm:px-8 md:px-10 lg:px-12 xl:px-16 grid grid-cols-3 items-center">
        {/* Left (empty) */}
        <div />

        {/* Center Logo */}
        <Link href="/" className="justify-self-center">
          <Logo className="w-26 h-fit" />
        </Link>

        {/* Right Button */}
        <div className="justify-self-end">
          <GetInTouchButton />
        </div>
      </div>
    </div>
  );
}
