import NumberedSection from "../NumberedSection";

export function PrivacySections() {
  return (
    <>
      <NumberedSection
        number="01"
        title="Introduction"
        content={
          <>
            At Ocean of Olives, we are committed to protecting your privacy and
            ensuring the security of your personal information. This Privacy
            Policy explains how we collect, use, disclose, and safeguard your
            data when you visit our website or use our services. By using our
            services, you consent to the practices described in this policy.
          </>
        }
      />
      <NumberedSection
        number="02"
        title="Who We Are"
        content={
          <>
            Ocean of Olives is an AI agency specialized in building chatbots
            that encode empathy with AI intelligence. We help e-commerce stores
            on social messaging platforms deliver exceptional customer
            experiences. Our contact information is:
            <br />
            <br />
            Email:{" "}
            <a
              href="mailto:support@oceanofolives.com"
              className="ml-2 text-black underline!"
            >
              support@oceanofolives.com
            </a>
          </>
        }
      />

      <NumberedSection
        number="03"
        title="Information We Collect"
        content={
          <>
            We may collect the following types of information:
            <ul className="mt-4 space-y-2 text-gray-700">
              <li>
                <strong>Personal Identification Information:</strong> Name,
                email address, phone number, job title, and company name
              </li>
              <li>
                <strong>Technical Data:</strong> IP address, browser type,
                operating system, referring URLs, and pages visited
              </li>
              <li>
                <strong>Usage Data:</strong> Information about how you interact
                with our website and services
              </li>
              <li>
                <strong>Communications:</strong> Records of your correspondence
                with us, including emails and support requests
              </li>
            </ul>
          </>
        }
      />

      <NumberedSection
        number="04"
        title="How We Collect Your Information"
        content={
          <>
            We collect information through various methods:
            <ul className="mt-4 space-y-2 text-gray-700">
              <li>
                Directly from you when you fill out forms, register for
                services, or contact us
              </li>
              <li>
                Automatically through cookies and similar tracking technologies
                when you visit our website
              </li>
              <li>
                From third-party sources, such as analytics providers or
                business partners, where permitted by law
              </li>
            </ul>
          </>
        }
      />

      <NumberedSection
        number="05"
        title="How We Use Your Information"
        content={
          <>
            We use the information we collect for the following purposes:
            <ul className="mt-4 space-y-2 text-gray-700">
              <li>To provide, maintain, and improve our services</li>
              <li>
                To communicate with you about our services, including responding
                to inquiries and providing support
              </li>
              <li>
                To send you updates, newsletters, and marketing communications
                (with your consent)
              </li>
              <li>
                To analyze usage patterns and improve our website and services
              </li>
              <li>To comply with legal obligations and protect our rights</li>
            </ul>
          </>
        }
      />

      <NumberedSection
        number="06"
        title="Data Security"
        content={
          <>
            We implement appropriate technical and organizational measures to
            protect your personal information from unauthorized access, loss,
            misuse, or alteration. However, no method of transmission over the
            internet or electronic storage is 100% secure. While we strive to
            protect your data, we cannot guarantee absolute security.
          </>
        }
      />

      <NumberedSection
        number="07"
        title="Data Retention"
        content={
          <>
            We retain your personal information only for as long as necessary to
            fulfill the purposes outlined in this Privacy Policy, unless a
            longer retention period is required or permitted by law. When your
            information is no longer needed, we will securely delete or
            anonymize it.
          </>
        }
      />

      <NumberedSection
        number="08"
        title="Your Rights"
        content={
          <>
            Depending on your location, you may have the following rights
            regarding your personal information:
            <ul className="mt-4 space-y-2 text-gray-700">
              <li>
                The right to access, update, or delete your personal information
              </li>
              <li>
                The right to object to or restrict the processing of your data
              </li>
              <li>The right to data portability</li>
              <li>
                The right to withdraw consent where we rely on your consent to
                process your data
              </li>
              <li>
                The right to lodge a complaint with a supervisory authority
              </li>
            </ul>
            <br />
            To exercise any of these rights, please contact us at{" "}
            <a
              href="mailto:support@oceanofolives.com"
              className="text-black underline!"
            >
              support@oceanofolives.com
            </a>
            .
          </>
        }
      />

      <NumberedSection
        number="09"
        title="International Data Transfers"
        content={
          <>
            Your information may be transferred to and processed in countries
            other than your country of residence. These countries may have data
            protection laws that differ from those in your country. By using our
            services, you consent to the transfer of your information to these
            countries. We will take appropriate measures to ensure that your
            data is treated securely and in accordance with this Privacy Policy.
          </>
        }
      />

      <NumberedSection
        number="10"
        title="Third-Party Links"
        content={
          <>
            Our website may contain links to third-party websites or services.
            We are not responsible for the privacy practices or content of these
            third parties. We encourage you to review the privacy policies of
            any third-party sites you visit.
          </>
        }
      />

      <NumberedSection
        number="11"
        title="Contact Us"
        content={
          <>
            If you have any questions or concerns about this Privacy Policy or
            our data practices, please contact us:
            <br />
            <br />
            Email:{" "}
            <a
              href="mailto:support@oceanofolives.com"
              className="text-black underline!"
            >
              support@oceanofolives.com
            </a>
          </>
        }
      />

      <NumberedSection
        number="12"
        title="Changes to This Policy"
        content={
          <>
            We may update this Privacy Policy from time to time to reflect
            changes in our practices or legal requirements. When we make
            changes, we will update the &quot;Last updated&quot; date at the top
            of this policy. We encourage you to review this policy periodically.
            Your continued use of our services after any changes indicates your
            acceptance of the updated policy.
          </>
        }
      />
    </>
  );
}
