import NumberedSection from "../NumberedSection";

export function TermsSections() {
  return (
    <>
      <NumberedSection
        number="01"
        title="Introduction"
        content={
          <>
            Welcome to Ocean of Olives. These Terms of Service govern your
            access to and use of our website, products, and services. By
            accessing or using any part of our services, you agree to be bound
            by these Terms. If you do not agree, you may not use our services.
          </>
        }
      />

      <NumberedSection
        number="02"
        title="Services Provided"
        content={
          <>
            Ocean of Olives offers AI-powered chatbot services that encode
            empathy with AI intelligence, which may include but are not limited
            to:
            <ul className="mt-4 space-y-2 text-gray-700">
              <li>
                Emotionally intelligent chatbot development for e-commerce
                businesses
              </li>
              <li>
                Brand voice modeling and integration across messaging platforms
              </li>
              <li>
                Customer conversation systems for social platforms (Facebook
                Messenger, WhatsApp, Instagram DMs, Telegram)
              </li>
              <li>
                Custom AI solutions that restore empathy in digital customer
                communication
              </li>
            </ul>
          </>
        }
      />

      <NumberedSection
        number="03"
        title="Changes to Terms"
        content={
          <>
            Ocean of Olives reserves the right to modify or replace these Terms
            at any time at our sole discretion. Changes will be effective
            immediately upon posting to our website. Your continued use of our
            services after any changes signifies your acceptance of the updated
            Terms. We encourage you to review these Terms periodically.
          </>
        }
      />

      <NumberedSection
        number="04"
        title="Account Registration"
        content={
          <>
            To access certain features of our services, you may need to register
            for an account. You agree to provide accurate, current, and complete
            information during the registration process and to update such
            information as necessary. You are responsible for safeguarding your
            account credentials and for any activities or actions under your
            account. You must notify us immediately of any unauthorized use of
            your account.
          </>
        }
      />

      <NumberedSection
        number="05"
        title="Privacy"
        content={
          <>
            Your privacy is important to us. Our Privacy Policy, which is
            incorporated into these Terms by reference, explains how we collect,
            use, and protect your personal information. By using our services,
            you consent to the collection and use of your information as
            described in our Privacy Policy.
          </>
        }
      />

      <NumberedSection
        number="06"
        title="User Conduct"
        content={
          <>
            You agree not to use our services for any unlawful purpose or in any
            way that could harm, disable, overburden, or impair our systems.
            Prohibited actions include, but are not limited to:
            <ul className="mt-4 space-y-2 text-gray-700">
              <li>
                Violating any applicable local, state, national, or
                international law
              </li>
              <li>
                Transmitting any harmful code, including viruses, worms, or
                trojans
              </li>
              <li>
                Engaging in unauthorized access to our systems or attempting to
                breach security measures
              </li>
              <li>
                Impersonating any person or entity or misrepresenting your
                affiliation
              </li>
            </ul>
          </>
        }
      />

      <NumberedSection
        number="07"
        title="Intellectual Property"
        content={
          <>
            All content and materials available through our services, including
            but not limited to text, graphics, logos, software, and data, are
            the property of Ocean of Olives or our licensors and are protected
            by copyright, trademark, and other intellectual property laws. You
            may not reproduce, distribute, modify, or create derivative works
            from any content without our express written permission.
          </>
        }
      />

      <NumberedSection
        number="08"
        title="Third-Party Services"
        content={
          <>
            Our services may contain links to or integrations with third-party
            websites or services that are not owned or controlled by Ocean of
            Olives. We have no control over, and assume no responsibility for,
            the content, privacy policies, or practices of any third-party
            services. You acknowledge and agree that Ocean of Olives shall not
            be liable for any damage or loss caused by your use of any
            third-party services.
          </>
        }
      />

      <NumberedSection
        number="09"
        title="Termination"
        content={
          <>
            We reserve the right to suspend or terminate your access to our
            services at any time, without notice, for conduct that we believe
            violates these Terms or is harmful to other users, us, or third
            parties, or for any other reason at our sole discretion. Upon
            termination, your right to use our services will immediately cease.
          </>
        }
      />

      <NumberedSection
        number="10"
        title="Changes to Service"
        content={
          <>
            Ocean of Olives reserves the right to modify, suspend, or
            discontinue any part of our services at any time, with or without
            notice. We will not be liable to you or any third party for any
            modification, suspension, or discontinuation of our services.
          </>
        }
      />

      <NumberedSection
        number="11"
        title="Disclaimer and Limitation of Liability"
        content={
          <>
            Our services are provided on an &quot;as is&quot; and &quot;as
            available&quot; basis without warranties of any kind, either express
            or implied. Ocean of Olives does not guarantee that our services
            will be uninterrupted, secure, or error-free. To the fullest extent
            permitted by law, Ocean of Olives shall not be liable for any
            indirect, incidental, special, consequential, or punitive damages
            arising out of or related to your use of our services.
          </>
        }
      />

      <NumberedSection
        number="12"
        title="Contact"
        content={
          <>
            If you have any questions about these Terms of Service, please
            contact us:
            <br />
            <br />
            Email:{" "}
            <a
              href="mailto:support@oceanofolives.com"
              className="text-black underline!"
            >
              support@oceanofolives.com
            </a>
          </>
        }
      />
    </>
  );
}
